program queue;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil;
type
  PQueue = ^Element; // указатель
  Element = record // структура записи
  data : integer; // содержательная часть очереди
  next : PQueue; // ссылка на следующий элемент
  end;
  TQueue = record // структура для реализации очереди
  first: PQueue; // указатель, указывает на первый элемент очереди
  last: PQueue; // указатель, указывает на последний элемент очереди
  end;

{ ============================================== }
procedure Put_Que(ELEM: integer; var Que: TQueue);
{ ============================================== }
var ukaz : PQueue; // временный указатель
begin
  if (Que.last = nil) then
  {Если очередь пуста, то указатели на первый
  и последний элемент будут совпадать}
  begin
    Que.last:= New(PQueue); // Выделяем память для нового элемента
    Que.first:= Que.last;  // Приравниваем указатели
    Que.last^.data:= ELEM; // записываем данные
    Que.last^.next:= nil; // Следующий элемент пока пустой
  end
  else
  begin
    ukaz:= New(PQueue);
    ukaz^.data:= ELEM;
    ukaz^.next:= nil;
    Que.last^.next:= ukaz; // ссылка на следующий элемент
    Que.last:= ukaz; // Сдвигаем указатель на последний элемент
  end;
end;

{ ================================================== }
procedure Take_Que(var ELEM: integer; var Que: TQueue;
                   var EMPTY: Boolean);
{ ================================================== }

var ukaz : PQueue;
begin
  if (Que.first = nil) then
  begin
    EMPTY:= true;
  end
  else
  begin
    ELEM:= Que.first^.data; {Первый элемент очереди}
    ukaz:= Que.first; // Запомним ссылку
    Que.first:= Que.first^.next; {переход на следующий элемент}
    Dispose(ukaz); {уничтожение текущего элемента}
  end;
end;

{ ============================================ }
procedure View_Que(var Que: TQueue);
{ ============================================ }

var
  ukaz: PQueue;
begin
  writeln(UTF8ToConsole('Содержимое очереди'));
  ukaz:= Que.first; // Берем первый элемент очереди
  {В цикле проходим все элементы очереди и печатаем их}
  while ukaz <> nil do
  begin
    write(ukaz^.data, ' ');
    ukaz:= ukaz^.next;
  end;
  writeln;
end;

var
  choose: integer;
  EMPTY: boolean;
  Que: TQueue;
  ELEM: integer; // содержательный элемент очереди
begin
  {Инициализация очереди}
  Que.last:= nil;
  repeat
    EMPTY:= false;
    writeln(UTF8ToConsole('Выберите нужный режим работы :'));
    writeln(UTF8ToConsole('Поместить элемент в очередь    1'));
    writeln(UTF8ToConsole('Взять элемент из очереди       2'));
    writeln(UTF8ToConsole('Просмотреть содержимое очереди 3'));
    writeln(UTF8ToConsole('Выход из программы             4'));
    readln(choose);
    case choose of
    1: begin
         writeln(UTF8ToConsole('Введите новый элемент очереди'));
         readln(ELEM);
         Put_Que(ELEM, Que);
       end;
    2: begin
         Take_Que(ELEM, Que, EMPTY);
         if EMPTY then
         begin
           writeln(UTF8ToConsole('Очередь пуста'));
         end
         else
         begin
           writeln(UTF8ToConsole('Из очереди взят элемент '), ELEM);
         end;
       end;
    3:begin
        View_Que(Que);
      end;
    end; { end of case }
  until choose = 4;
end.
